# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .mime_type import MimeType


class BlobStorageReference(UniversalBaseModel):
    """
    A reference to content offloaded to blob storage
    """

    type: typing.Literal["blob-storage"] = "blob-storage"
    path: str = pydantic.Field()
    """
    Path to the content in blob storage
    """

    mime_type: MimeType = pydantic.Field()
    """
    MIME type of the content
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
