# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class BudgetLimitUnit(str, enum.Enum):
    """
    Unit for budget limit calculation
    """

    COST_PER_DAY = "cost_per_day"
    COST_PER_MONTH = "cost_per_month"
    TOKENS_PER_DAY = "tokens_per_day"
    TOKENS_PER_MONTH = "tokens_per_month"

    def visit(
        self,
        cost_per_day: typing.Callable[[], T_Result],
        cost_per_month: typing.Callable[[], T_Result],
        tokens_per_day: typing.Callable[[], T_Result],
        tokens_per_month: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is BudgetLimitUnit.COST_PER_DAY:
            return cost_per_day()
        if self is BudgetLimitUnit.COST_PER_MONTH:
            return cost_per_month()
        if self is BudgetLimitUnit.TOKENS_PER_DAY:
            return tokens_per_day()
        if self is BudgetLimitUnit.TOKENS_PER_MONTH:
            return tokens_per_month()
