# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .build_build_source import BuildBuildSource
from .build_build_spec import BuildBuildSpec


class Build(UniversalBaseModel):
    """
    Describes how we build our code into a Docker image.
    """

    type: typing.Literal["build"] = pydantic.Field(default="build")
    """
    +value=build
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    build_source: BuildBuildSource = pydantic.Field()
    """
    Source code location.
    """

    build_spec: BuildBuildSpec = pydantic.Field()
    """
    Instructions to build a container image out of the build source
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
