# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .chat_prompt_manifest_mcp_servers_item import ChatPromptManifestMcpServersItem
from .chat_prompt_manifest_messages_item import ChatPromptManifestMessagesItem
from .chat_prompt_manifest_response_format import ChatPromptManifestResponseFormat
from .chat_prompt_manifest_routing_config import ChatPromptManifestRoutingConfig
from .guardrails import Guardrails
from .mcp_server_tool_details import McpServerToolDetails
from .model_configuration import ModelConfiguration
from .tool_schema import ToolSchema


class ChatPromptManifest(UniversalBaseModel):
    """
    Chat Prompt manifest.
    """

    name: str = pydantic.Field()
    """
    Name of the entity
    """

    description: typing.Optional[str] = None
    metadata: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Key value metadata. Should be valid JSON. For e.g. `{"business-unit": "sales", "quality": "good", "rating": 4.5}`
    """

    version_alias: typing.Optional[str] = pydantic.Field(default=None)
    """
    Version alias is alternate, ideally human readable, version string to reference an artifact version. It should start with `v` followed by alphanumeric and it can include `.` and `-` in between (e.g. `v1.0.0`, `v1-prod`, `v3-dev`, etc)
    """

    ml_repo: str = pydantic.Field()
    """
    Name of the ML Repo
    """

    version: typing.Optional[int] = pydantic.Field(default=None)
    """
    Version of the entity
    """

    type: typing.Literal["chat_prompt"] = "chat_prompt"
    messages: typing.List[ChatPromptManifestMessagesItem] = pydantic.Field()
    """
    List of messages in the chat conversation, must be non-empty
    """

    variables: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Variables referenced in messages and that can be replaced when running generation
    """

    model_configuration: typing.Optional[ModelConfiguration] = None
    tools: typing.Optional[typing.List[ToolSchema]] = pydantic.Field(default=None)
    """
    List of tools to be used in the chat prompt
    """

    mcp_servers: typing.Optional[typing.List[ChatPromptManifestMcpServersItem]] = pydantic.Field(default=None)
    """
    A list of MCP servers FQNs or URLs and their tools
    """

    guardrails: typing.Optional[Guardrails] = None
    response_format: typing.Optional[ChatPromptManifestResponseFormat] = pydantic.Field(default=None)
    """
    Response format configuration for structured outputs
    """

    routing_config: typing.Optional[ChatPromptManifestRoutingConfig] = pydantic.Field(default=None)
    """
    Configuration for routing requests to different model targets
    """

    tool_call_to_mcp_mapping: typing.Optional[typing.Dict[str, McpServerToolDetails]] = pydantic.Field(default=None)
    """
    Mapping of tool calls to MCP server integration IDs and tool names
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
