# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .cloudera_integrations import ClouderaIntegrations
from .cloudera_provider_account_auth_data import ClouderaProviderAccountAuthData
from .collaborator import Collaborator
from .owned_by import OwnedBy


class ClouderaProviderAccount(UniversalBaseModel):
    """
    Cloudera Provider Account
    """

    type: typing.Literal["provider-account/cloudera"] = pydantic.Field(default="provider-account/cloudera")
    """
    +value=provider-account/cloudera
    """

    name: str = pydantic.Field()
    """
    The name of the Cloudera provider account
    """

    auth_data: ClouderaProviderAccountAuthData = pydantic.Field()
    """
    Cloudera authentication credentials
    """

    base_url: str = pydantic.Field()
    """
    The base URL of your Cloudera CDP environment. This should be the CDP API endpoint URL for your region and environment.
    """

    integrations: typing.List[ClouderaIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the Cloudera provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
