# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClouderaTokenAuth(UniversalBaseModel):
    """
    Authenticate using a pre-generated API token. Alternative to workload authentication, this method uses a directly provided API token for accessing Cloudera CDP services.
    """

    type: typing.Literal["token"] = pydantic.Field(default="token")
    """
    +value=token
    """

    api_token: str = pydantic.Field()
    """
    Pre-generated API token for Cloudera CDP authentication. You can generate this token using the CDP CLI or from your user profile settings. This token provides direct access to CDP services without requiring workload-specific authentication.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
