# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ClouderaWorkloadAuthToken(UniversalBaseModel):
    """
    Authenticate using Cloudera CDP workload authentication (recommended). This method generates a secure workload token using your API access key and private key, allowing you to securely access CDP workloads and services.
    """

    type: typing.Literal["workload-auth-token"] = pydantic.Field(default="workload-auth-token")
    """
    +value=workload-auth-token
    """

    access_key_id: str = pydantic.Field()
    """
    The access key ID for your Cloudera CDP workload authentication.
    """

    private_key: str = pydantic.Field()
    """
    The private key for your Cloudera CDP workload authentication.
    """

    workload_name: str = pydantic.Field()
    """
    The name of the CDP workload you want to authenticate with.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
