# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .cluster_manifest_cluster_type import ClusterManifestClusterType
from .cluster_manifest_monitoring import ClusterManifestMonitoring
from .cluster_manifest_node_label_keys import ClusterManifestNodeLabelKeys
from .cluster_manifest_workbench_config import ClusterManifestWorkbenchConfig
from .collaborator import Collaborator
from .ingress_controller_config import IngressControllerConfig
from .nodepool import Nodepool
from .owned_by import OwnedBy
from .spark_config import SparkConfig


class ClusterManifest(UniversalBaseModel):
    type: typing.Literal["cluster"] = pydantic.Field(default="cluster")
    """
    +value=cluster
    """

    name: str = pydantic.Field()
    """
    Name - 3 to 35 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    cluster_type: ClusterManifestClusterType = pydantic.Field()
    """
    The cluster type of this cluster
    """

    environment_names: typing.List[str] = pydantic.Field()
    """
    Tag the environment like dev, staging or production. You will need to [create environments](https://docs.truefoundry.com/docs/key-concepts#creating-environments) if you don't have already.
    """

    base_domains: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    One or more base URLs, which can be either a wildcard domain (resulting in app URLs like `<app-name>-<workspace-name>.<base-domain-URL>`) or a non-wildcard domain (resulting in app URLs like `<base-domain-URL>/<app-name>-<workspace-name>`)
    > Read more about routing [here](https://docs.truefoundry.com/docs/routing) and about 'A' record and domain mapping [here](https://docs.truefoundry.com/docs/setting-up-domain)
    """

    monitoring: typing.Optional[ClusterManifestMonitoring] = pydantic.Field(default=None)
    """
    Monitoring
    """

    default_registry_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cluster Default Registry
    """

    workbench_config: typing.Optional[ClusterManifestWorkbenchConfig] = pydantic.Field(default=None)
    """
    Workbench Config
    """

    spark_config: typing.Optional[SparkConfig] = None
    ingress_controller_config: typing.Optional[IngressControllerConfig] = None
    cluster_integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cluster Integration FQN
    """

    workflow_storage_integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Workflow Storage Integration
    """

    supported_nodepools: typing.Optional[typing.List[Nodepool]] = pydantic.Field(default=None)
    """
    Add nodepools that are already created in your cluster.
    When deploying, applications can choose to schedule from these nodepools.
    """

    node_label_keys: typing.Optional[ClusterManifestNodeLabelKeys] = pydantic.Field(default=None)
    """
    The node label keys that this cluster supports.
    Note: You will additionally need to add `truefoundry.com/gpu_type` label for GPU-supported node pools.
    For more information, check out [this documentation](https://docs.truefoundry.com/docs/generic-control-plane#configuring-node-pools-for-truefoundry).
    """

    collaborators: typing.List[Collaborator] = pydantic.Field()
    """
    Collaborators who can access this cluster
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
