# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CommonToolsSettings(UniversalBaseModel):
    """
    Describes the configuration for Common Tools MCP Server in AI Gateway
    """

    type: typing.Literal["settings/common-tools"] = pydantic.Field(default="settings/common-tools")
    """
    +value=settings/common-tools
    """

    web_search: bool = pydantic.Field(default=True)
    """
    Enable web search tool
    Allows model to search the web for information.
    """

    code_executor: bool = pydantic.Field(default=True)
    """
    Enable code executor tool
    Allows model to execute code and return the results.
    """

    sequential_thinking: bool = pydantic.Field(default=True)
    """
    Enable sequential thinking tool
    Allows model to reason step-by-step to solve complex problems.
    """

    vision_ocr: bool = pydantic.Field(default=True)
    """
    Enable vision OCR tool
    Allows model to extract text from images or PDFs.
    """

    web_scrape: bool = pydantic.Field(default=True)
    """
    Enable web scraping tool.
    Allows model to scrape content from web pages with intelligent format selection for structured or unstructured data.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
