# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .container_task_config_image import ContainerTaskConfigImage
from .container_task_config_mounts_item import ContainerTaskConfigMountsItem
from .resources import Resources


class ContainerTaskConfig(UniversalBaseModel):
    type: typing.Literal["container-task-config"] = pydantic.Field(default="container-task-config")
    """
    +value=container-task-config
    """

    image: ContainerTaskConfigImage = pydantic.Field()
    """
    Specify whether you want to deploy a Docker image or build and deploy from source code
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Configure environment variables to be injected in the task either as plain text or secrets. [Docs](https://docs.truefoundry.com/docs/env-variables)
    """

    resources: typing.Optional[Resources] = None
    mounts: typing.Optional[typing.List[ContainerTaskConfigMountsItem]] = pydantic.Field(default=None)
    """
    Configure data to be mounted to Workflow pod(s) as a volume.
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    Service Account
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
