# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .nats_user_password_auth import NatsUserPasswordAuth


class CoreNatsOutputConfig(UniversalBaseModel):
    """
    Describes the configuration for the output Core NATS worker
    """

    type: typing.Literal["core-nats"] = pydantic.Field(default="core-nats")
    """
    +value=core-nats
    """

    nats_url: str = pydantic.Field()
    """
    Output NATS URL
    """

    root_subject: str = pydantic.Field()
    """
    Root subject of output NATS
    """

    auth: typing.Optional[NatsUserPasswordAuth] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
