# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_basic_auth import CustomBasicAuth


class CustomBlobStorage(UniversalBaseModel):
    """
    Custom Blob Storage
    """

    type: typing.Literal["integration/blob-storage/custom"] = pydantic.Field(default="integration/blob-storage/custom")
    """
    +value=integration/blob-storage/custom
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    endpoint: str = pydantic.Field()
    """
    The endpoint of the storage provider.
    """

    storage_root: str = pydantic.Field()
    """
    The root path of the storage.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The region where the storage is located.
    """

    auth_data: CustomBasicAuth
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
