# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_guardrail_config_auth_data import CustomGuardrailConfigAuthData
from .custom_guardrail_config_operation import CustomGuardrailConfigOperation
from .custom_guardrail_config_target import CustomGuardrailConfigTarget


class CustomGuardrailConfig(UniversalBaseModel):
    """
    Custom
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/custom"] = pydantic.Field(
        default="integration/guardrail-config/custom"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/custom
    """

    operation: CustomGuardrailConfigOperation = pydantic.Field()
    """
    The operation type to use for the Guardrail. Validate guardrails are used to validate requests and mutate can validate as well as mutate requests.
    Validate guardrails are run in parallel while mutate guardrails are run sequentially.
    """

    target: CustomGuardrailConfigTarget = pydantic.Field()
    """
    Specify whether the guardrail should be applied to the request or response. Guardrails with target "Request" can be only used in input guardrails and guardrails with target "Response" can only be used in output guardrails.
    """

    url: str = pydantic.Field()
    """
    The URL of the Guardrail to send a post request to.
    """

    auth_data: typing.Optional[CustomGuardrailConfigAuthData] = pydantic.Field(default=None)
    """
    Authentication data for the Guardrail Server.
    """

    headers: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Headers for the Guardrail Server. Forwarded to the Guardrail Server as is. For example: `{"Authorization": "APIKey <token>"}`
    """

    config: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The config for the Guardrail Server. This is a JSON object that will be sent as a config to Guardrail Server along with the request.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
