# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .custom_basic_auth import CustomBasicAuth


class CustomHelmRepo(UniversalBaseModel):
    """
    Custom Helm Repo
    """

    type: typing.Literal["integration/helm-repo/custom"] = pydantic.Field(default="integration/helm-repo/custom")
    """
    +value=integration/helm-repo/custom
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    repo_url: str = pydantic.Field()
    """
    The URL of the Helm Repo.
    """

    auth_data: CustomBasicAuth
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
