# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .custom_basic_auth import CustomBasicAuth
from .custom_integrations import CustomIntegrations
from .owned_by import OwnedBy


class CustomProviderAccount(UniversalBaseModel):
    """
    Custom
    """

    type: typing.Literal["provider-account/custom"] = pydantic.Field(default="provider-account/custom")
    """
    +value=provider-account/custom
    """

    name: str = pydantic.Field()
    """
    The name of the provider account.
    """

    auth_data: typing.Optional[CustomBasicAuth] = None
    integrations: typing.List[CustomIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
