# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CustomTlsSettings(UniversalBaseModel):
    """
    Configure TLS settings for secure connections with custom CA certificates.
    """

    reject_unauthorized: bool = pydantic.Field(default=True)
    """
    When set to true, it will reject any connection which is not authorized with the list of supplied CAs.
    """

    ca_cert: typing.Optional[str] = pydantic.Field(default=None)
    """
    Add custom CA certificates to use for TLS verification.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
