# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .databricks_integrations import DatabricksIntegrations
from .databricks_provider_account_auth_data import DatabricksProviderAccountAuthData
from .owned_by import OwnedBy


class DatabricksProviderAccount(UniversalBaseModel):
    """
    Databricks Provider Account
    """

    type: typing.Literal["provider-account/databricks"] = pydantic.Field(default="provider-account/databricks")
    """
    +value=provider-account/databricks
    """

    name: str = pydantic.Field()
    """
    The name of the Databricks provider account
    """

    auth_data: DatabricksProviderAccountAuthData = pydantic.Field()
    """
    Databricks authentication credentials
    """

    base_url: str = pydantic.Field()
    """
    The base URL of your Databricks workspace
    """

    integrations: typing.List[DatabricksIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the Databricks provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
