# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class DeepinfraModel(UniversalBaseModel):
    """
    DeepInfra Model
    """

    type: typing.Literal["integration/model/deepinfra"] = pydantic.Field(default="integration/model/deepinfra")
    """
    +value=integration/model/deepinfra
    """

    name: str = pydantic.Field()
    """
    A descriptive name to identify this model integration in the UI
    """

    model_id: str = pydantic.Field()
    """
    The DeepInfra model identifier (e.g., meta-llama/Llama-3.3-70B-Instruct-Turbo, mistralai/Mistral-Small-24B-Instruct-2501). This is the full model path from DeepInfra's model catalog.
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Specify the type of the DeepInfra model
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
