# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .deepinfra_integrations import DeepinfraIntegrations
from .deepinfra_key_auth import DeepinfraKeyAuth
from .owned_by import OwnedBy


class DeepinfraProviderAccount(UniversalBaseModel):
    """
    DeepInfra Provider Account
    """

    type: typing.Literal["provider-account/deepinfra"] = pydantic.Field(default="provider-account/deepinfra")
    """
    +value=provider-account/deepinfra
    """

    name: str = pydantic.Field()
    """
    The name of the DeepInfra provider account
    """

    auth_data: DeepinfraKeyAuth
    integrations: typing.Optional[typing.List[DeepinfraIntegrations]] = pydantic.Field(default=None)
    """
    List of integrations that are associated with the DeepInfra provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
