# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .build_info import BuildInfo
from .deployment_manifest import DeploymentManifest
from .deployment_status import DeploymentStatus
from .recommendation import Recommendation
from .subject import Subject


class Deployment(UniversalBaseModel):
    id: typing.Optional[str] = None
    version: typing.Optional[float] = None
    fqn: typing.Optional[str] = None
    application_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="applicationId")] = None
    manifest: DeploymentManifest
    application: typing.Optional["Application"] = None
    created_by_subject: typing_extensions.Annotated[Subject, FieldMetadata(alias="createdBySubject")]
    created_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="createdAt")] = None
    updated_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="updatedAt")] = None
    deployment_builds: typing_extensions.Annotated[
        typing.Optional[typing.List[BuildInfo]], FieldMetadata(alias="deploymentBuilds")
    ] = None
    deployment_statuses: typing_extensions.Annotated[
        typing.Optional[typing.List[DeploymentStatus]], FieldMetadata(alias="deploymentStatuses")
    ] = None
    current_status_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="currentStatusId")] = None
    current_status: typing_extensions.Annotated[
        typing.Optional[DeploymentStatus], FieldMetadata(alias="currentStatus")
    ] = None
    applied_recommendations: typing_extensions.Annotated[
        typing.Optional[typing.List[Recommendation]], FieldMetadata(alias="appliedRecommendations")
    ] = pydantic.Field(default=None)
    """
    Applied recommendations for this deployment
    """

    created_by: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="createdBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


from .application import Application  # noqa: E402, I001

update_forward_refs(Deployment)
