# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DeploymentTransition(str, enum.Enum):
    BUILDING = "BUILDING"
    DEPLOYING = "DEPLOYING"
    REUSING_EXISTING_BUILD = "REUSING_EXISTING_BUILD"
    COMPONENTS_DEPLOYING = "COMPONENTS_DEPLOYING"
    WAITING = "WAITING"
    EMPTY = ""

    def visit(
        self,
        building: typing.Callable[[], T_Result],
        deploying: typing.Callable[[], T_Result],
        reusing_existing_build: typing.Callable[[], T_Result],
        components_deploying: typing.Callable[[], T_Result],
        waiting: typing.Callable[[], T_Result],
        empty: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is DeploymentTransition.BUILDING:
            return building()
        if self is DeploymentTransition.DEPLOYING:
            return deploying()
        if self is DeploymentTransition.REUSING_EXISTING_BUILD:
            return reusing_existing_build()
        if self is DeploymentTransition.COMPONENTS_DEPLOYING:
            return components_deploying()
        if self is DeploymentTransition.WAITING:
            return waiting()
        if self is DeploymentTransition.EMPTY:
            return empty()
