# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .docker_file_build_command import DockerFileBuildCommand


class DockerFileBuild(UniversalBaseModel):
    """
    Describes that we are using a dockerfile to build our image
    """

    type: typing.Literal["dockerfile"] = pydantic.Field(default="dockerfile")
    """
    +value=dockerfile
    """

    dockerfile_path: str = pydantic.Field(default="./Dockerfile")
    """
    The file path of the Dockerfile relative to project root path.
    """

    build_context_path: str = pydantic.Field(default="./")
    """
    Build context path for the Dockerfile relative to project root path.
    """

    command: typing.Optional[DockerFileBuildCommand] = pydantic.Field(default=None)
    """
    Override the command to run when the container starts
    When deploying a Job, the command can be templatized by defining `params` and referencing them in command
    E.g. `python main.py --learning_rate {{learning_rate}}`
    """

    build_args: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Build arguments to pass to docker build
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
