# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .dockerhub_basic_auth import DockerhubBasicAuth
from .dockerhub_integrations import DockerhubIntegrations
from .owned_by import OwnedBy


class DockerhubProviderAccount(UniversalBaseModel):
    """
    Dockerhub
    """

    type: typing.Literal["provider-account/dockerhub"] = pydantic.Field(default="provider-account/dockerhub")
    """
    +value=provider-account/dockerhub
    """

    name: str = pydantic.Field()
    """
    3 to 36 lower case characters long alphanumeric word, may contain - in between, cannot start with a number
    """

    account_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Account Name
    """

    auth_data: typing.Optional[DockerhubBasicAuth] = None
    integrations: typing.List[DockerhubIntegrations] = pydantic.Field()
    """
    +uiType=IntegrationsGroup
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
