# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DynamicVolumeConfig(UniversalBaseModel):
    """
    Create new volume
    """

    type: typing.Literal["dynamic"] = pydantic.Field(default="dynamic")
    """
    Volume Type for the volume.
    """

    storage_class: str = pydantic.Field()
    """
    Name of the storage class to be used for the volume.
    """

    size: int = pydantic.Field()
    """
    Size of volume in Gi
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
