# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .enkrypt_ai_guardrail_config_operation import EnkryptAiGuardrailConfigOperation
from .enkrypt_ai_key_auth import EnkryptAiKeyAuth


class EnkryptAiGuardrailConfig(UniversalBaseModel):
    """
    Enkrypt AI
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/enkrypt-ai"] = pydantic.Field(
        default="integration/guardrail-config/enkrypt-ai"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/enkrypt-ai
    """

    operation: EnkryptAiGuardrailConfigOperation = pydantic.Field()
    """
    The operation type to use for the Guardrail. Validate guardrails are used to validate requests and mutate can validate as well as mutate requests.
    Validate guardrails are run in parallel while mutate guardrails are run sequentially.
    """

    guardrail_name: str = pydantic.Field()
    """
    The name of the guardrail to use for the Enkrypt AI Guardrail.
    """

    auth_data: EnkryptAiKeyAuth

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
