# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .environment_color import EnvironmentColor
from .environment_optimize_for import EnvironmentOptimizeFor


class EnvironmentManifest(UniversalBaseModel):
    type: typing.Literal["environment"] = pydantic.Field(default="environment")
    """
    +value=environment
    """

    name: str = pydantic.Field()
    """
    Environment Name
    """

    color: EnvironmentColor
    is_production: typing_extensions.Annotated[bool, FieldMetadata(alias="isProduction")] = pydantic.Field()
    """
    Environment Type - Indicates if the environment is for production use
    """

    optimize_for: typing_extensions.Annotated[EnvironmentOptimizeFor, FieldMetadata(alias="optimizeFor")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
