# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .event_chart import EventChart
from .event_involved_object import EventInvolvedObject


class Event(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the event
    """

    first_timestamp: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="firstTimestamp")] = (
        pydantic.Field(default=None)
    )
    """
    Timestamp when the event was first observed
    """

    last_timestamp: typing_extensions.Annotated[str, FieldMetadata(alias="lastTimestamp")] = pydantic.Field()
    """
    Timestamp when the event was last observed
    """

    involved_object: typing_extensions.Annotated[EventInvolvedObject, FieldMetadata(alias="involvedObject")] = (
        pydantic.Field()
    )
    """
    Details of the involved object
    """

    type: str = pydantic.Field()
    """
    Type of the event
    """

    count: int = pydantic.Field()
    """
    Number of occurrences of the event
    """

    reason: str = pydantic.Field()
    """
    Reason for the event
    """

    message: str = pydantic.Field()
    """
    Message describing the event
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    Namespace of the event
    """

    chart: EventChart = pydantic.Field()
    """
    Chart of the event
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
