# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .fiddler_guard_type import FiddlerGuardType
from .fiddler_key_auth import FiddlerKeyAuth


class FiddlerGuardrailConfig(UniversalBaseModel):
    """
    Fiddler
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config.
    """

    type: typing.Literal["integration/guardrail-config/fiddler"] = pydantic.Field(
        default="integration/guardrail-config/fiddler"
    )
    """
    +uiType=Hidden
    +value=integration/guardrail-config/fiddler
    """

    auth_data: FiddlerKeyAuth
    guard_type: FiddlerGuardType
    threshold: typing.Optional[float] = pydantic.Field(default=None)
    """
    Confidence threshold (0.0-1.0) for flagging content. Content scoring above the threshold will be flagged
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
