# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .gcp_integrations import GcpIntegrations
from .gcp_provider_account_auth_data import GcpProviderAccountAuthData
from .owned_by import OwnedBy


class GcpProviderAccount(UniversalBaseModel):
    """
    GCP
    """

    type: typing.Literal["provider-account/gcp"] = pydantic.Field(default="provider-account/gcp")
    """
    +value=provider-account/gcp
    """

    name: str = pydantic.Field()
    """
    The name of the GCP provider account.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The project id of the GCP account.
    """

    auth_data: typing.Optional[GcpProviderAccountAuthData] = pydantic.Field(default=None)
    """
    Authentication data for the GCP account.
    """

    integrations: typing.List[GcpIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the GCP provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
