# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GcpTpu(UniversalBaseModel):
    type: typing.Literal["gcp_tpu"] = pydantic.Field(default="gcp_tpu")
    """
    +value=gcp_tpu
    """

    name: str = pydantic.Field()
    """
    Name of the TPU Type. One of
      - `tpu-v4-podslice` (TPU v4, ct4p)
      - `tpu-v5-lite-device` (TPU v5e, ct5l)
      - `tpu-v5-lite-podslice`  (TPU v5e, ct5lp)
      - `tpu-v5p-slice` (TPU v5p, ct5p)
    """

    topology: str = pydantic.Field()
    """
    Topology of the TPU slices. Currently only single-host topology is supported.
     Please refer to [TPUs on GKE docs](https://cloud.google.com/kubernetes-engine/docs/concepts/tpus#plan-tpu-configuration)
     Allowed Values:
       - `2x2x1` for `tpu-v4-podslice`
       - One of `1x1`, `2x2`, `2x4` for `tpu-v5-lite-device` and `tpu-v5-lite-podslice`
       - `2x2x1` for `tpu-v5p-slice`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
