# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .model_cost_metric import ModelCostMetric
from .model_type import ModelType


class GeminiModel(UniversalBaseModel):
    """
    Gemini Model
    """

    type: typing.Literal["integration/model/gemini"] = pydantic.Field(default="integration/model/gemini")
    """
    +value=integration/model/gemini
    """

    name: str = pydantic.Field()
    """
    A descriptive name to identify this model integration in the UI
    """

    model_id: str = pydantic.Field()
    """
    The Google Gemini model identifier (e.g., gemini-2.0-flash, gemini-2.0-flash-lite-preview-02-05, gemini-2.0-flash-lite-preview-02-05). This is the standard model name from Google's Gemini API documentation.
    """

    model_types: typing.List[ModelType] = pydantic.Field()
    """
    Specify the type of the Gemini model (e.g., chat, text, etc.)
    """

    cost: typing.Optional[ModelCostMetric] = None
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
