# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GitHelmRepo(UniversalBaseModel):
    type: typing.Literal["git-helm-repo"] = pydantic.Field(default="git-helm-repo")
    """
    +value=git-helm-repo
    """

    repo_url: str = pydantic.Field()
    """
    Git repository URL - Needs to be a valid URL.
    """

    revision: str = pydantic.Field()
    """
    Branch/Commit SHA/Tag of the git repo.
    """

    path: str = pydantic.Field()
    """
    Path to the chart.
    """

    value_files: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Helm values files for overriding values in the helm chart.
    The path is relative to the Path directory defined above
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
