# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class GitSource(UniversalBaseModel):
    """
    Describes that we are using code stored in a git repository to build our image
    """

    type: typing.Literal["git"] = pydantic.Field(default="git")
    """
    +value=git
    """

    repo_url: str = pydantic.Field()
    """
    The repository URL.
    """

    ref: str = pydantic.Field()
    """
    The commit SHA.
    """

    branch_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Selecting branch will select latest commit SHA of the branch.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
