# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .gcp_api_key_auth import GcpApiKeyAuth
from .gemini_model import GeminiModel
from .owned_by import OwnedBy


class GoogleGeminiProviderAccount(UniversalBaseModel):
    """
    Google Gemini Provider Account
    """

    type: typing.Literal["provider-account/google-gemini"] = pydantic.Field(default="provider-account/google-gemini")
    """
    +value=provider-account/google-gemini
    """

    name: str = pydantic.Field()
    """
    The name of the Google Gemini provider account
    """

    auth_data: GcpApiKeyAuth
    integrations: typing.List[GeminiModel] = pydantic.Field()
    """
    List of integrations that are associated with the Google Gemini provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
