# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .gcp_key_file_auth import GcpKeyFileAuth
from .gcp_region import GcpRegion
from .owned_by import OwnedBy
from .vertex_model import VertexModel


class GoogleVertexProviderAccount(UniversalBaseModel):
    """
    Google Vertex Provider Account
    """

    type: typing.Literal["provider-account/google-vertex"] = pydantic.Field(default="provider-account/google-vertex")
    """
    +value=provider-account/google-vertex
    """

    name: str = pydantic.Field()
    """
    The name of the Google Vertex provider account
    """

    project_id: str = pydantic.Field()
    """
    The Google Cloud project ID where Vertex AI is enabled
    """

    region: GcpRegion
    auth_data: typing.Optional[GcpKeyFileAuth] = None
    integrations: typing.List[VertexModel] = pydantic.Field()
    """
    List of integrations that are associated with the Google Vertex provider account
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this provider account
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
