# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class GraphChartType(str, enum.Enum):
    """
    Chart type
    """

    LINE = "line"
    VERTICAL_LINE = "vertical_line"
    STACKED_BAR = "stacked_bar"
    STACKED_AREA = "stacked_area"
    BUBBLE = "bubble"
    HORIZONTAL_BAR = "horizontal_bar"
    HORIZONTAL_STACKED_BAR = "horizontal_stacked_bar"
    HORIZONTAL_BOX_PLOT = "horizontal_box_plot"

    def visit(
        self,
        line: typing.Callable[[], T_Result],
        vertical_line: typing.Callable[[], T_Result],
        stacked_bar: typing.Callable[[], T_Result],
        stacked_area: typing.Callable[[], T_Result],
        bubble: typing.Callable[[], T_Result],
        horizontal_bar: typing.Callable[[], T_Result],
        horizontal_stacked_bar: typing.Callable[[], T_Result],
        horizontal_box_plot: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is GraphChartType.LINE:
            return line()
        if self is GraphChartType.VERTICAL_LINE:
            return vertical_line()
        if self is GraphChartType.STACKED_BAR:
            return stacked_bar()
        if self is GraphChartType.STACKED_AREA:
            return stacked_area()
        if self is GraphChartType.BUBBLE:
            return bubble()
        if self is GraphChartType.HORIZONTAL_BAR:
            return horizontal_bar()
        if self is GraphChartType.HORIZONTAL_STACKED_BAR:
            return horizontal_stacked_bar()
        if self is GraphChartType.HORIZONTAL_BOX_PLOT:
            return horizontal_box_plot()
