# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .collaborator import Collaborator
from .guardrail_config_integrations import GuardrailConfigIntegrations
from .owned_by import OwnedBy


class GuardrailConfigGroup(UniversalBaseModel):
    """
    Guardrail Configs Group
    """

    type: typing.Literal["provider-account/guardrail-config-group"] = pydantic.Field(
        default="provider-account/guardrail-config-group"
    )
    """
    +uiType=Hidden
    +value=provider-account/guardrail-config-group
    """

    name: str = pydantic.Field()
    """
    The name of the Guardrail Config Group.
    """

    collaborators: typing.Optional[typing.List[Collaborator]] = pydantic.Field(default=None)
    """
    List of users who have access to this Guardrail Config Group.
    """

    integrations: typing.List[GuardrailConfigIntegrations] = pydantic.Field()
    """
    List of Guardrail Configs, which are part of this Guardrail Config Group.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
