# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .hashicorp_token_auth import HashicorpTokenAuth


class HashicorpVaultIntegration(UniversalBaseModel):
    """
    HashiCorp Vault Integration
    """

    type: typing.Literal["integration/secret-store/hashicorp/vault"] = pydantic.Field(
        default="integration/secret-store/hashicorp/vault"
    )
    """
    +value=integration/secret-store/hashicorp/vault
    """

    name: str = pydantic.Field()
    """
    The name of the integration that will be displayed in the TrueFoundry UI.
    """

    vault_url: str = pydantic.Field()
    """
    The URL of the HashiCorp Vault server (e.g., https://vault.example.com:8200).
    """

    auth_data: HashicorpTokenAuth
    authorized_subjects: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of subjects that are authorized to access this integration. List of user fqn in format <user_type>:<username>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
