# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .helm_source import HelmSource
from .kustomize import Kustomize


class Helm(UniversalBaseModel):
    type: typing.Literal["helm"] = pydantic.Field(default="helm")
    """
    +value=helm
    """

    name: str = pydantic.Field()
    """
    Name of the Helm deployment. This will be set as the release name of the chart you are deploying.
    """

    labels: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Add labels to base argo app
    """

    source: HelmSource = pydantic.Field()
    """
    Source helm repository
    """

    values: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Values file as block file
    """

    kustomize: typing.Optional[Kustomize] = None
    ignore_differences: typing_extensions.Annotated[
        typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]],
        FieldMetadata(alias="ignoreDifferences"),
    ] = None
    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Fully qualified name of the workspace
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
