# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HelmRepo(UniversalBaseModel):
    type: typing.Literal["helm-repo"] = pydantic.Field(default="helm-repo")
    """
    +value=helm-repo
    """

    repo_url: str = pydantic.Field()
    """
    Helm repository URL - Needs to be a valid URL.
    """

    integration_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the helm repo integration. If you can't find your integration here,
    add it through the [Integrations](/integrations) page
    """

    chart: str = pydantic.Field()
    """
    The helm chart name
    """

    version: str = pydantic.Field()
    """
    Helm chart version
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
