# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .http_error_code import HttpErrorCode


class HttpError(UniversalBaseModel):
    status_code: typing_extensions.Annotated[int, FieldMetadata(alias="statusCode")] = pydantic.Field()
    """
    HTTP Status Code
    """

    message: str = pydantic.Field()
    """
    Error Message
    """

    code: typing.Optional[HttpErrorCode] = pydantic.Field(default=None)
    """
    Error code
    """

    details: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    Error details
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
