# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HttpProbe(UniversalBaseModel):
    """
    Describes the Instructions for assessing container health by executing an HTTP GET request.
    To learn more you can go [here](https://docs.truefoundry.com/docs/liveness-readiness-probe)
    """

    type: typing.Literal["http"] = pydantic.Field(default="http")
    """
    Request Type
    """

    path: str = pydantic.Field()
    """
    Path to the health check endpoint
    """

    port: int = pydantic.Field()
    """
    Listening port for the health check endpoint
    """

    host: typing.Optional[str] = pydantic.Field(default=None)
    """
    Host name to connect to, defaults to the pod IP
    """

    scheme: typing.Optional[str] = pydantic.Field(default="HTTP")
    """
    Scheme to use for connecting to the host
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
