# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class HuggingfaceArtifactSource(UniversalBaseModel):
    """
    Input for Artifact from Huggingface Model Hub
    """

    type: typing.Literal["huggingface-hub"] = pydantic.Field(default="huggingface-hub")
    """
    +value=huggingface-hub
    """

    model_id: str = pydantic.Field()
    """
    Model ID of the artifact to be downloaded
    """

    revision: str = pydantic.Field()
    """
    Revision of the artifact to be downloaded
    """

    ignore_patterns: typing.List[str] = pydantic.Field()
    """
    List of patterns to ignore while downloading the artifact
    """

    download_path_env_variable: str = pydantic.Field()
    """
    Environment variable which will contain the download path of the artifact
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
