# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .image_command import ImageCommand


class Image(UniversalBaseModel):
    """
    Describes that we are using a pre-built image stored in a Docker Image registry
    """

    type: typing.Literal["image"] = pydantic.Field(default="image")
    """
    +value=image
    """

    image_uri: str = pydantic.Field()
    """
    The image URI. Specify the name of the image and the tag.
    If the image is in Dockerhub, you can skip registry-url (for e.g. `tensorflow/tensorflow`).
    You can use an image from a private registry using Advanced fields
    """

    docker_registry: typing.Optional[str] = pydantic.Field(default=None)
    """
    FQN of the container registry. If you can't find your registry here,
    add it through the [Integrations](/integrations?tab=docker-registry) page
    """

    command: typing.Optional[ImageCommand] = pydantic.Field(default=None)
    """
    Override the command to run when container starts.
    When deploying a Job, the command can be templatized by defining `params` and referencing them in command
    E.g. `python main.py --learning_rate {{learning_rate}}`
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
