# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class IngressControllerConfig(UniversalBaseModel):
    ingress_class_name: str = pydantic.Field(default="nginx")
    """
    Ingress Class Name
    """

    tls_enabled: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Whether TLS is managed by the ingress controller. If enabled, the ingress object will have TLS configuration.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
