# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .j_frog_integrations import JFrogIntegrations
from .jfrog_basic_auth import JfrogBasicAuth
from .owned_by import OwnedBy


class JfrogProviderAccount(UniversalBaseModel):
    """
    Jfrog
    """

    type: typing.Literal["provider-account/jfrog"] = pydantic.Field(default="provider-account/jfrog")
    """
    +value=provider-account/jfrog
    """

    name: str = pydantic.Field()
    """
    The name of the provider account.
    """

    account_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the JFrog account.
    """

    auth_data: typing.Optional[JfrogBasicAuth] = None
    integrations: typing.List[JFrogIntegrations] = pydantic.Field()
    """
    List of integrations that are associated with the provider account.
    """

    owned_by: typing_extensions.Annotated[typing.Optional[OwnedBy], FieldMetadata(alias="ownedBy")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
