# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .job_alert import JobAlert
from .job_image import JobImage
from .job_mounts_item import JobMountsItem
from .job_trigger import JobTrigger
from .kustomize import Kustomize
from .param import Param
from .resources import Resources


class Job(UniversalBaseModel):
    """
    Describes the configuration for the job
    """

    type: typing.Literal["job"] = pydantic.Field(default="job")
    """
    +value=job
    """

    name: str = pydantic.Field()
    """
    Name of the job
    """

    image: JobImage = pydantic.Field()
    """
    Specify whether you want to deploy a Docker image or build and deploy from source code
    """

    trigger: JobTrigger = pydantic.Field()
    """
    Specify the trigger
    """

    trigger_on_deploy: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Trigger the job after deploy immediately
    """

    params: typing.Optional[typing.List[Param]] = pydantic.Field(default=None)
    """
    Configure params and pass it to create different job runs
    """

    env: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    Configure environment variables to be injected in the service either as plain text or secrets. [Docs](https://docs.truefoundry.com/docs/env-variables)
    """

    resources: typing.Optional[Resources] = None
    alerts: typing.Optional[typing.List[JobAlert]] = pydantic.Field(default=None)
    """
    Configure alerts to be sent when the job starts/fails/completes
    """

    retries: typing.Optional[int] = pydantic.Field(default=0)
    """
    Specify the maximum number of attempts to retry a job before it is marked as failed.
    """

    timeout: typing.Optional[int] = pydantic.Field(default=None)
    """
    Job timeout in seconds.
    """

    concurrency_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of runs that can run concurrently
    """

    service_account: typing.Optional[str] = pydantic.Field(default=None)
    """
    +sort=1000
    """

    mounts: typing.Optional[typing.List[JobMountsItem]] = pydantic.Field(default=None)
    """
    Configure data to be mounted to job pod(s) as a string, secret or volume. [Docs](https://docs.truefoundry.com/docs/mounting-volumes-job)
    """

    labels: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Labels
    """

    kustomize: typing.Optional[Kustomize] = None
    workspace_fqn: typing.Optional[str] = pydantic.Field(default=None)
    """
    Fully qualified name of the workspace
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
