# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .notification_target import NotificationTarget


class JobAlert(UniversalBaseModel):
    """
    Describes the configuration for the job alerts
    """

    notification_channel: typing.Optional[str] = pydantic.Field(default=None)
    """
    Specify the notification channel to send alerts to
    """

    to_emails: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of recipients' email addresses if the notification channel is Email.
    """

    notification_target: typing.Optional[NotificationTarget] = None
    on_start: typing.Optional[bool] = pydantic.Field(default=False)
    """
    Send an alert when the job starts
    """

    on_completion: typing.Optional[bool] = False
    on_failure: typing.Optional[bool] = pydantic.Field(default=True)
    """
    Send an alert when the job fails
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
