# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .job_run_status import JobRunStatus
from .subject import Subject


class JobRun(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    JobRun Name
    """

    application_name: typing_extensions.Annotated[str, FieldMetadata(alias="applicationName")] = pydantic.Field()
    """
    Application Name
    """

    deployment_version: typing_extensions.Annotated[str, FieldMetadata(alias="deploymentVersion")] = pydantic.Field()
    """
    Deployment Version
    """

    created_at: typing_extensions.Annotated[float, FieldMetadata(alias="createdAt")] = pydantic.Field()
    """
    Created At
    """

    end_time: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="endTime")] = pydantic.Field(
        default=None
    )
    """
    End Time of JobRun
    """

    duration: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration of JobRun
    """

    command: str = pydantic.Field()
    """
    Command
    """

    total_retries: typing_extensions.Annotated[int, FieldMetadata(alias="totalRetries")] = pydantic.Field()
    """
    Total Retries
    """

    error: typing.Optional[str] = pydantic.Field(default=None)
    """
    Error
    """

    status: JobRunStatus = pydantic.Field()
    """
    Status of JobRun
    """

    triggered_by: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="triggeredBy")] = (
        pydantic.Field(default=None)
    )
    """
    Triggered By
    """

    triggered_by_subject: typing_extensions.Annotated[
        typing.Optional[Subject], FieldMetadata(alias="triggeredBySubject")
    ] = pydantic.Field(default=None)
    """
    Triggered By Subject
    """

    exit_code: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="exitCode")] = pydantic.Field(
        default=None
    )
    """
    Exit Code
    """

    spark_ui: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="sparkUi")] = pydantic.Field(
        default=None
    )
    """
    Spark UI Url
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
