# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .json_schema import JsonSchema


class JsonSchemaResponseFormat(UniversalBaseModel):
    """
    Structured JSON response format with schema validation
    """

    type: typing.Literal["json_schema"] = pydantic.Field(default="json_schema")
    """
    Type of response format
    """

    json_schema: JsonSchema

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow")  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
